<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

include "config.php";
include "xero_token.php";

$xero_quotes = getTodayModifiedQuotes();

// echo json_encode($xero_quotes);
// exit;

foreach($xero_quotes as $quote){
    
    $xero_quote_json =json_encode($quote);

    $QuoteID = $quote['QuoteID'];
    $Reference = $quote['Reference'] ?? null;
    $xero_Contact = $quote['Contact'];
    
    $xero_contact_name = !empty($xero_Contact['Name']) ? $xero_Contact['Name'] : "test jon";
    $xero_contact_firstName = !empty($xero_Contact['FirstName']) ? $xero_Contact['FirstName'] : "test";
    // $xero_contact_lastName = !empty($xero_Contact['LastName']) ? $xero_Contact['LastName'] : "jon";
    $xero_contact_email = !empty($xero_Contact['EmailAddress']) ? $xero_Contact['EmailAddress'] : "jontest@gmail.com";
    
    $DateString = $quote['DateString'];
    $ExpiryDateString = $quote['ExpiryDateString'];
    
    $formatted_invoice_date = date('Y-m-d', strtotime($DateString));
    $formatted_expiry_date = date('Y-m-d', strtotime($ExpiryDateString));
    
    $xero_currencyCode = $quote['CurrencyCode'];
    $xero_status = $quote['Status'];
    $LineAmountTypes = $quote['LineAmountTypes'];
    
    $xero_quote_items = $quote['LineItems'];
    
    
    if($xero_status == 'DRAFT'){
        $estimateStatus = 'draft';
    }elseif($xero_status == 'SENT'){
        $estimateStatus = 'sent';
    }elseif($xero_status == 'DECLINED'){
        $estimateStatus = 'declined';
    }elseif($xero_status == 'ACCEPTED'){ 
        $estimateStatus = 'accepted';
    }elseif($xero_status == 'INVOICED'){ 
        $estimateStatus = 'invoiced';
    }
    
    $taxInclusive = false;
    
    $ghl_quote_items=[];
    foreach($xero_quote_items as $xe_item){
        $UnitAmount = $xe_item['UnitAmount'];
        $Quantity = $xe_item['Quantity'];
        $TaxType = $xe_item['TaxType'];
        $TaxAmount = $xe_item['TaxAmount'];
        $LineAmount = $xe_item['LineAmount'];
        
        $tax_rate = calculateTaxRate($TaxAmount, $LineAmount);
                    
                    
        $name = $xe_item['Item']['Name'] ?? null;
        
        if(empty($name)){
            $ItemCode = $xe_item['ItemCode'];
            
            $name = ucwords(str_replace('-', ' ', $ItemCode));
        }
        
        $product_id = getProductsFromGHL($name);
        if(empty($product_id)){
            $productData = [
                "name" => $name,
                "locationId" => $location_id,
                "description" => $name,
                "productType" => "PHYSICAL",
                "availableInStore" => true
            ];
            
            $new_product = createGHLProduct($productData);
            echo json_encode($new_product);
            $product_id = $new_product['_id'];
        }
                    

        $quote_item=[
            "name" => $name,
            "productId" => $product_id,
            "currency" => $xero_currencyCode,
            // "amount" => $UnitAmount,
            "qty" => $Quantity,
            "type" => "one_time"
        ];
        
        
        if($LineAmountTypes == 'EXCLUSIVE' && $TaxType != 'NONE'){
            $quote_item['taxes']=[
                [
                    '_id' => '67fc0da0c1a9900ad1bdfc73',
                    'name' => $TaxType,
                    'rate' => $tax_rate,
                    'calculation' => 'exclusive',
                ]
            ];
            $quote_item['amount'] = $UnitAmount;
            
        }elseif($LineAmountTypes == 'INCLUSIVE' && $TaxType != 'NONE'){
            $quote_item['taxes']=[
                [
                    '_id' => '67fc0da0c1a9900ad1bdfc73',
                    'name' => $TaxType,
                    'rate' => $tax_rate,
                    'calculation' => 'exclusive',
                ]
            ];
            
            $new_lineTotal = $LineAmount + $TaxAmount;
            
            $Newunit_amount = $new_lineTotal/$Quantity;
            
            
            $quote_item['amount'] = $Newunit_amount;
            $taxInclusive = true;
        }
        
        $quote_item['taxInclusive'] = $taxInclusive;
           
        $ghl_quote_items[] = $quote_item;
    }
    
    
    
    $ghl_contactdetails = getGhlContactByEmail($xero_contact_email);
                
    if(!empty($ghl_contactdetails['contacts'])){
        
        $ghl_contactId = $ghl_contactdetails['contacts'][0]['id'];
        $ghl_contact_name = $ghl_contactdetails['contacts'][0]['contactName'];
        
        echo "GHL contact found contact id : $ghl_contactId<br> \n";
        
    }else{
        
        echo "GHL contact not found. Creating new Contact <br> \n";
        
        $full_name = "$xero_contact_firstName $xero_contact_lastName";
        $data = [
            "firstName" => $xero_contact_firstName,
            // "lastName" => $xero_contact_lastName,
            "email" => $xero_contact_email,
            "locationId" => $location_id
        ];
        
        $ghlNewContact = createGhlContact($data);
        
        $ghl_contactId = $ghlNewContact['contact']['id'];
        $ghl_contact_name = $xero_contact_name;
        
        echo "New GHL Contact Created Sucessfully.. Contact Id : $ghl_contactId <br> \n";
    }
    
    
    
    
    $query = "SELECT * FROM estimates WHERE xero_quote_id = '$QuoteID'";
    $result = $conn->query($query);
                    
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        
        
        $ghl_estimateId = $row['ghl_estimate_id'];
        
        echo "Estimate found in db XeroId : $QuoteID and GHL id : $ghl_estimateId <br>\n";
        
        $payload = [
            "altId" => $location_id,
            "altType" => "location",
            "name" => "New Estimate",
            "businessDetails" => [
                "name" => $ghl_contact_name,
            ],
            "currency" => "USD",
            "items" => $ghl_quote_items,
            "discount" => [],
            "contactDetails" => [
                "id" => $ghl_contactId,
                "name" => $ghl_contact_name,
                "email" => $xero_contact_email
            ],
            "issueDate" => $formatted_invoice_date,
            "expiryDate" => $formatted_expiry_date,
            "estimateStatus" => $estimateStatus,
            "frequencySettings" => [
                "enabled" => true,
                "schedule" => []
            ]
        ];
        // echo "<br><br> \n";
        // echo json_encode($payload);
        // echo "<br><br> \n";
        
        
        $update_response = updateEstimate($ghl_estimateId, $payload);
        
        if($update_response && isset($update_response['_id'])){
            $estimateId = $update_response['_id'];
            echo "Estimate update in GHL estimateId : $estimateId <br> \n";
            if($estimateStatus == 'sent'){
                $send_status = sendEstimate($estimateId);
                if($send_status){
                    echo "Estimate send sucessfully. <br>\n";
                }else{
                    echo "Error sending Estimate. <br>\n";
                }
            }
        }

    }else{
        echo  "No estimate exist in db against xero quote id $QuoteID .... <br> \n";
        $new_EstimateNumber = generateEstimateNumber();
        $payload = [
            "altId" => $location_id,
            "altType" => "location",
            "name" => "New Estimate",
            "businessDetails" => [
                "name" => $ghl_contact_name,
            ],
            "currency" => "USD",
            "items" => $ghl_quote_items,
            "discount" => [],
            "title" => "Estimate",
            "contactDetails" => [
                "id" => $ghl_contactId,
                "name" => $ghl_contact_name,
                "email" => $xero_contact_email
            ],
            "estimateNumber" => $new_EstimateNumber,
            "issueDate" => $formatted_invoice_date,
            "expiryDate" => $formatted_expiry_date,
            // "estimateStatus" => $estimateStatus,
            "frequencySettings" => [
                "enabled" => true,
                "schedule" => []
            ]
        ];
        // echo "<br><br> \n";
        // echo json_encode($payload);
        // echo "<br><br> \n";
        
        $create_response = createEstimate($payload);
        if($create_response && isset($create_response['_id'])){
            $ghl_response = json_encode($create_response);
            $new_estimateId = $create_response['_id'];
            
            echo "New estimate created in GHL estimate id : $new_estimateId <br>\n";
            
            if($estimateStatus == 'sent'){
                $send_status = sendEstimate($new_estimateId);
                if($send_status){
                    echo "Estimate send sucessfully. <br>\n";
                }else{
                    echo "Error sending Estimate. <br>\n";
                }
            }
            
            $stmt = $conn->prepare("INSERT INTO estimates (ghl_estimate_id, xero_quote_id, ghl_response, xero_response) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("ssss", $new_estimateId, $QuoteID, $ghl_response, $xero_quote_json);
                
            if ($stmt->execute()) {
                echo "New estimate data store in db.";       
            } else {
                echo "Error storing invoice: " . $stmt->error;
            }
        }
        
    }
    // exit;
}


function getTodayModifiedQuotes(){
    
    global $tenant_id;
    $accessToken=getTeamAccessToken();
    
    $url = 'https://api.xero.com/api.xro/2.0/Quotes';
    $todayUtc = gmdate('Y-m-d\T00:00:00');

    $headers = [
        "Authorization: Bearer $accessToken",
        "Xero-tenant-id: $tenant_id",
        "Accept: application/json",
        "If-Modified-Since: $todayUtc"
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_errno($ch)) {
        $error = curl_error($ch);
        curl_close($ch);
        throw new Exception("Request Error: $error");
    }

    curl_close($ch);

    if ($httpCode === 200) {
        return json_decode($response, true)['Quotes'] ?? [];
    } elseif ($httpCode === 304) {
        // No modifications since today
        return [];
    } else {
        throw new Exception("Unexpected HTTP Code: $httpCode. Response: $response");
    }
}

function calculateTaxRate($taxAmount, $lineAmount){
    
    if ($lineAmount == 0) {
        return 0;
    }

    $rate = ($taxAmount / $lineAmount) * 100;
    return round($rate, 2); 
}

function getProductsFromGHL($searchTerm) {
    global $location_id;
    $accessToken = ghl_getAccessToken();
    $url = "https://services.leadconnectorhq.com/products/?locationId=" . urlencode($location_id) . "&search=" . urlencode($searchTerm);

    $headers = [
        "Accept: application/json",
        "Authorization: Bearer {$accessToken}",
        "Version: 2021-07-28"
    ];

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => $headers,
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
        return ["error" => $err];
    } 
    
    $data = json_decode($response, true);
    
    if($data['products']){
        $product_id = $data['products'][0]['_id'];
        return $product_id;
    }else{
        return null;
    }
}

function createGHLProduct($productData) {
    $accessToken = ghl_getAccessToken();
    $url = "https://services.leadconnectorhq.com/products/";

    $headers = [
        "Accept: application/json",
        "Authorization: Bearer {$accessToken}",
        "Content-Type: application/json",
        "Version: 2021-07-28"
    ];

    $payload = json_encode($productData);

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => $headers,
    ]);

    $response = curl_exec($curl);
    $error = curl_error($curl);

    curl_close($curl);

    if ($error) {
        return ["error" => $error];
    }

    return json_decode($response, true);
}

function getGhlContactByEmail($email) {
    global $location_id;
    $accessToken = ghl_getAccessToken();
    $url = "https://services.leadconnectorhq.com/contacts/?locationId=" . urlencode($location_id) . "&query=" . urlencode($email);

    $headers = [
        "Accept: application/json",
        "Authorization: Bearer $accessToken",
        "Version: 2021-07-28"
    ];

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        return ["error" => $err];
    }

    return json_decode($response, true);
}

function createGhlContact($data) {
    // global $location_id;
    $accessToken = ghl_getAccessToken();

    $url = 'https://services.leadconnectorhq.com/contacts/';

    $headers = [
        "Accept: application/json",
        "Authorization: Bearer $accessToken",
        "Content-Type: application/json",
        "Version: 2021-07-28"
    ];
    
    $ch = curl_init($url);
    
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_errno($ch)) {
        return 'Request Error:' . curl_error($ch);
    }
    // echo $response;
    // exit;
    curl_close($ch);

    return json_decode($response, true);
}

function generateEstimateNumber() {
    global $location_id;
    $accessToken = ghl_getAccessToken();
    $altType = 'location';
    $url = "https://services.leadconnectorhq.com/invoices/estimate/number/generate?altId={$location_id}&altType={$altType}";

    $headers = [
        "Accept: application/json",
        "Authorization: Bearer {$accessToken}",
        "Version: 2021-07-28"
    ];

    $ch = curl_init();

    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPGET => true,
        CURLOPT_HTTPHEADER => $headers
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err) {
        echo $err;
    }
    
    if($httpCode == 200 || $httpCode == 201){
        $decode_data = json_decode($response, true);
        $estimateNumber = $decode_data['estimateNumber'];
        // $full_est_no = "EST-$estimateNumber";
        return $estimateNumber;
    }
    echo $response;
    echo "<br> \n";
}


function updateEstimate($estimateId, $payload) {
    
    $accessToken = ghl_getAccessToken();
    
    $url = "https://services.leadconnectorhq.com/invoices/estimate/{$estimateId}";

    $headers = [
        "Authorization: Bearer $accessToken",
        "Version: 2021-07-28",
        "Content-Type: application/json"
    ];

    $ch = curl_init($url);

    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_errno($ch)) {
        $error = curl_error($ch);
        curl_close($ch);
       echo $error;
    }

    curl_close($ch);
    
    if($httpCode == 200 || $httpCode == 201){
        return json_decode($response, true);
    }
    
    echo $response;
    echo "<br> \n";
}


function createEstimate($data) {
    
    $accessToken = ghl_getAccessToken();
    
    $url = "https://services.leadconnectorhq.com/invoices/estimate";

    $headers = [
        "Authorization: Bearer {$accessToken}",
        "Version: 2021-07-28",
        "Content-Type: application/json"
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err) {
        echo $err;
    }
    
    if($httpCode == 200 || $httpCode == 201){
        return json_decode($response, true);
    }
    
    echo $response;
    echo "<br> \n";
}


function sendEstimate($estimateId) {
    global $location_id;
    global $user_id;
    global $user_email;
    global $user_name;
    
    $accessToken = ghl_getAccessToken();
    
    $url = "https://services.leadconnectorhq.com/invoices/estimate/{$estimateId}/send";

    $payload = [
        "altId" => $location_id,
        "altType" => "location",
        "action" => "email",
        "liveMode" => true,
        "userId" => $user_id,
        "sentFrom" => [
            "fromName" => $user_name,
            "fromEmail" => $user_email
        ],
    ];

    $headers = [
        "Accept: application/json",
        "Authorization: Bearer {$accessToken}",
        "Content-Type: application/json",
        "Version: 2021-07-28"
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if (curl_errno($ch)) {
        echo 'cURL error: ' . curl_error($ch);
    }
    
    curl_close($ch);
    
    if($httpCode == 200 || $httpCode == 201){
        return true;
    }else{
        echo"<br>\n";
        echo "HTTP Status Code: $httpCode\n";
        echo "Response:\n$response";
        echo"<br>\n";
        return false;
    }
}


