<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "config.php";
include "xero_token.php";


$postData = file_get_contents('php://input');

$myfile = fopen("estimate.txt", "a") or die("Unable to open file!");
$txt = $postData . "\n";
fwrite($myfile, $txt);
fclose($myfile);

$data = json_decode($postData, true);

$contact_id = $data['contact_id'];

$estimate_data = getEstimateList($contact_id);

$estimates =  $estimate_data['estimates'] ?? null;

if(!empty($estimates)){
    // echo json_encode($estimates);
    foreach($estimates as $estimate){
        $ghlEstimate_id = $estimate['_id'];
        $estimateStatus = $estimate['estimateStatus'];
        
        if($estimateStatus == 'draft'){
            $xero_estimateStatus = 'DRAFT';
        }elseif($estimateStatus == 'sent'){
            $xero_estimateStatus = 'SENT';
        }elseif($estimateStatus == 'declined'){
            $xero_estimateStatus = 'DECLINED';
        }elseif($estimateStatus == 'accepted'){
            $xero_estimateStatus = 'ACCEPTED';
        }elseif($estimateStatus == 'invoiced'){
            $xero_estimateStatus = 'INVOICED';
        }
        
        $issueDate = $estimate['issueDate'];
        $expiryDate = $estimate['expiryDate'];
        
        $formatted_isseu_date = date('Y-m-d', strtotime($issueDate));
        $formatted_expiryDate = date('Y-m-d', strtotime($expiryDate));
        
        $estimate_items = $estimate['items'];
        
        $custom_items=[];
        foreach($estimate_items as $item){
            $name = $item['name'];
            $qty = $item['qty'];
            $amount = $item['amount'];
            $description = !empty($item['description']) ? $item['description'] : $name;
            
            $total_tax=0;
            $taxes = $item['taxes'];
            $taxInclusive = $item['taxInclusive'];
            $LineAmountTypes = 'NoTax';
            
            if (isset($item['taxes']) && is_array($item['taxes']) && !empty($item['taxes'])) {
                foreach ($item['taxes'] as $tax) {
                    // Calculate tax based on the rate and whether it's inclusive or exclusive
                    if ($taxInclusive) {
                        $LineAmountTypes = 'Inclusive';
                        // Tax is included in the amount - need to calculate the tax portion
                        // Formula: tax = (amount * rate) / (100 + rate)
                        $total_tax += (($amount * $qty) * $tax['rate']) / (100 + $tax['rate']);
                    } else {
                        
                        $LineAmountTypes = 'Exclusive';
                        // Tax is added on top of the amount
                        $total_tax += ($amount * $qty) * ($tax['rate'] / 100);
                    }
                }
            }
            
            $xero_itemCode = getItemCodeByName($name);

            if (!$xero_itemCode) {
                $converted_name = convertToSlug($name);
                $xeroNewItem = [
                    "Code" => $converted_name,
                    "Name" => $name,
                    "Description" => $description
                ];
                $xero_itemCode = createXeroItem($xeroNewItem);
            }
            
            $line_item = [
                "Description" => $description,
                "Quantity" => $qty,
                "UnitAmount" => $amount,
                "ItemCode" => $xero_itemCode,
                "AccountCode" => $account_code,
            ];
        
            if ($LineAmountTypes !== 'NoTax') {
                $line_item["TaxType"] = "OUTPUT";
                $line_item["TaxAmount"] = $total_tax;
            }
        
            $custom_items[] = $line_item;
            
        }
        
        
        $custom_data=[
            "ghl_contact_id" => $contact_id,
            "ghl_estimate_id" => $ghlEstimate_id,
            "first_name" => $data['first_name'] ?? 'n/a',
            "last_name" => $data['last_name'] ?? 'n/a',
            "full_name" => $data['full_name'] ?? 'n/a',
            "email" => $data['email'],
            "location_name" => $data['location']['name'],
            "location_id" => $data['location']['id'],
            "LineItems" => $custom_items,
            "issue_date" => $formatted_isseu_date,
            "expiry_date" => $formatted_expiryDate,
            "lineAmountTypes" => $LineAmountTypes,
            "estimate_status" => $xero_estimateStatus,
        ];
        

        $query = "SELECT * FROM estimates WHERE ghl_estimate_id = '$ghlEstimate_id'";
        $result = $conn->query($query);
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $xero_quote_id = $row['xero_quote_id'] ?? null;
            
            if($xero_quote_id){
                $custom_data['isUpdate'] = true;
            }else{
                $custom_data['isUpdate'] = false;
            }
            
            if($estimateStatus == 'sent'){
                $custom_data['isSent'] = true;
            }else{
                $custom_data['isSent'] = false;
            }
            $xero_contact_id = getXeroContactByEmail($data['email']);
            
            if(empty($xero_contact_id)){
                // JSON payload
                $data = [
                    'Contacts' => [
                        [
                            'Name' => $data['full_name'],
                            'FirstName' => $data['first_name'],
                            // 'LastName' => $data['last_name'],
                            'EmailAddress' => $data['email']
                        ]
                    ]
                ];
                
               $xero_contact_id = createXeroContact($data);
            }
            
            $quote_data = [
                "QuoteID" => $xero_quote_id,
                "Reference" => $ghlEstimate_id,
                "Contact" => [
                    "ContactID" => $xero_contact_id
                ],
                "LineItems" => $custom_items,
                "Date" => $formatted_isseu_date,
                "ExpiryDate" => $formatted_expiryDate,
                "Status" => $xero_estimateStatus,
                "LineAmountTypes" => $LineAmountTypes
            ];
            
            $update_status = updateXeroQuote($quote_data);
            
            // send_dataTo_make($custom_data);
        }else{
            $json_data = json_encode($estimate);
            
            $stmt = $conn->prepare("INSERT INTO estimates (ghl_estimate_id, ghl_response) VALUES (?, ?)");
            $stmt->bind_param("ss", $ghlEstimate_id, $json_data);
                
            if ($stmt->execute()) {
                echo "New invoice store in db.";       
            } else {
                echo "Error storing invoice: " . $stmt->error;
            }
                
            $stmt->close();
            
            $custom_data['isUpdate'] = false;
            
            if($estimateStatus == "sent"){
                $custom_data['isSent'] = true;
            }else{
                $custom_data['isSent'] = false;
            }
            send_dataTo_make($custom_data);
        }
        
    }
}

// ghl get estimates
function getEstimateList($contactId)
{
    global $location_id;
    
    $bearerToken = ghl_getAccessToken();
    
    $startAt = date('Y-m-d');
    // $startAt = '2025-04-28';
    
    $url = "https://services.leadconnectorhq.com/invoices/estimate/list?" . http_build_query([
        'altId'    => $location_id,
        'altType'  => 'location',
        'startAt'  => $startAt,
        'contactId'=> $contactId,
        'limit'    => 10,
        'offset'   => 0,
    ]);

    $headers = [
        'Accept: application/json',
        'Authorization: Bearer '.$bearerToken,
        'Version: 2021-07-28',
    ];

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers,
    ]);

    $response = curl_exec($curl);

    if (curl_errno($curl)) {
        $error = curl_error($curl);
        curl_close($curl);
        return ['error' => $error];
    }

    curl_close($curl);
    return json_decode($response, true);
}


function getItemCodeByName($item_name) {
    global $tenant_id;
    $access_token=getTeamAccessToken();
    
    $url = 'https://api.xero.com/api.xro/2.0/Items?where=' . urlencode('Name=="' . $item_name . '"');

    $headers = [
        'Authorization: Bearer ' . $access_token,
        'Xero-tenant-id: ' . $tenant_id,
        'Accept: application/json'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Curl error: ' . curl_error($ch);
        return false;
    }

    curl_close($ch);

    $data = json_decode($response, true);
    
    if(!empty($data['Items'])){
        $item_code = $data['Items'][0]['Code'];
        return $item_code;
    }else{
        return null;
    }
}

function createXeroItem($data) {
    
    global $tenant_id;
    $access_token=getTeamAccessToken();
    
    $url = "https://api.xero.com/api.xro/2.0/Items";

    $headers = [
        "Authorization: Bearer $access_token",
        "Xero-tenant-id: $tenant_id",
        "Content-Type: application/json",
        "Accept: application/json"
    ];

    $jsonData = json_encode($data);

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

    $response = curl_exec($ch);
    $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_errno($ch)) {
        echo 'Curl error: ' . curl_error($ch);
    }

    curl_close($ch);

    if($http_status == 200){
        $item_data = json_decode($response, true);
        $item_code = $item_data['Items'][0]['Code'];
        return $item_code;
    }else{
        // echo $response;
        return null;
    }
    
}

function convertToSlug($string) {
    // Convert to lowercase
    $slug = strtolower($string);
    
    // Replace spaces and underscores with dash
    $slug = preg_replace('/[\s_]+/', '-', $slug);
    
    // // Remove all non-alphanumeric characters except dash
    // $slug = preg_replace('/[^a-z0-9\-]/', '', $slug);
    
    // Trim dashes from ends
    $slug = trim($slug, '-');
    return $slug;
}

function getXeroContactByEmail($email){
    
    global $tenant_id;
    $access_token=getTeamAccessToken();
    
    $url = 'https://api.xero.com/api.xro/2.0/Contacts?where=EmailAddress="' . $email . '"';

    // Headers
    $headers = [
        "Authorization: Bearer $access_token",
        "Xero-tenant-id: $tenant_id",
        "Content-Type: application/json",
        "Accept: application/json"
    ];

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        $error_msg = curl_error($ch);
        curl_close($ch);
        echo $error_msg;
    }

    curl_close($ch);
    
    $data = json_decode($response, true);
    
    $contact = $data['Contacts'] ?? null;
    if(!empty($contact)){
        $contact_id = $contact[0]['ContactID'];
    }else{
        $contact_id = null;
    }
    
    return $contact_id;
}

function createXeroContact($data){
    
    global $tenant_id;
    $access_token=getTeamAccessToken();
    
    $url = 'https://api.xero.com/api.xro/2.0/Contacts';

    $headers = [
        "Authorization: Bearer $access_token",
        "Xero-tenant-id: $tenant_id",
        "Content-Type: application/json",
        "Accept: application/json"
    ];

    // Initialize cURL
    $ch = curl_init($url);

    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    // Execute and handle response
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        $error = curl_error($ch);
        curl_close($ch);
        echo $error;
    }

    curl_close($ch);
    
    $data = json_decode($response, true);
    
    $contact = $data['Contacts'] ?? null;
    if(!empty($contact)){
        $contact_id = $contact[0]['ContactID'];
    }else{
        $contact_id = null;
    }
    
    return $contact_id;
    
}

function updateXeroQuote($data){
    
    global $tenant_id;
    $access_token=getTeamAccessToken();
    
    $url = 'https://api.xero.com/api.xro/2.0/Quotes';

    $headers = [
        "Authorization: Bearer $access_token",
        "Xero-tenant-id: $tenant_id",
        "Content-Type: application/json",
        "Accept: application/json"
    ];

    

    $ch = curl_init($url);

    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_errno($ch)) {
        echo  curl_error($ch);
        
    }

    curl_close($ch);
    
    if($http_status == 200 || $http_status == 201){
        // echo $response;
        $myfile = fopen("estimate.txt", "a") or die("Unable to open file!");
        $txt = $response . "\n";
        fwrite($myfile, $txt);
        fclose($myfile);
        return true;
        
    }
}

function send_dataTo_make($custom_data){
    // Send POST request to Make webhook
    $webhook_url = "https://hook.us2.make.com/wdu6bt5w97eei0ebi16s6p52cw8hnt3q";
    
    $ch = curl_init($webhook_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($custom_data));
    
    $response = curl_exec($ch);
    
    if (curl_errno($ch)) {
        echo 'Error sending data to webhook: ' . curl_error($ch);
    } else {
        
        $myfile1 = fopen("estimate.txt", "a") or die("Unable to open file!");
        $txt1 = "Make data received status:" .$response . "\n";
        fwrite($myfile1, $txt1);
        fclose($myfile1);
    }
    
    curl_close($ch);

}
