<?php
include "config.php";

if (!isset($_GET['code'])) {

    $auth_url = "https://login.xero.com/identity/connect/authorize?response_type=code"
          . "&client_id={$xero_client_id}"
          . "&redirect_uri=" .urlencode($xero_redirect_uri)
          . "&scope=".urlencode($xero_scope);

    header("Location: " . $auth_url);
    exit;
}

$authorization_code = $_GET['code'];

$basic_auth = base64_encode($xero_client_id . ':' . $xero_client_secret);

$ch = curl_init();

curl_setopt($ch, CURLOPT_URL, 'https://identity.xero.com/connect/token');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);

curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Basic ' . $basic_auth,
    'Content-Type: application/x-www-form-urlencoded'
]);

$post_fields = http_build_query([
    'grant_type' => 'authorization_code',
    'code' => $authorization_code,
    'redirect_uri' => $xero_redirect_uri
]);

curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);

$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo 'Curl error: ' . curl_error($ch);
}

curl_close($ch);

// echo $response;

$token_info = json_decode($response, true);

if (isset($token_info['access_token'])) {
    $accessToken = $token_info['access_token'];
    $refreshToken = $token_info['refresh_token'];
    $token_type = $token_info['token_type'];
    $expires_in = $token_info['expires_in'];
    $expires_time = time() + $expires_in;
    $scope = $token_info['scope'];

    // Store tokens in database
    $stmt = $conn->prepare("INSERT INTO xero_token (access_token, refresh_token, expires_in, expires_time, 	scope) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $accessToken, $refreshToken, $expires_in, $expires_time, $scope);
    
    if ($stmt->execute()) {
        echo "Tokens stored successfully.";          
    } else {
        echo "Error storing tokens: " . $stmt->error;
    }
    
    $stmt->close();

    
} else {
    echo "Failed to obtain access token!";
}



