<?php

// include "config.php";

function refrechAccessToken($refresh_token){
    global $xero_client_id;
    global $xero_client_secret;
    global $xero_redirect_uri;
    

    $url = 'https://identity.xero.com/connect/token';
    $basic_auth = base64_encode($xero_client_id . ':' . $xero_client_secret);

    $headers = [
        'Authorization: Basic ' . $basic_auth,
        'Content-Type: application/x-www-form-urlencoded'
    ];

    $body = http_build_query([
        'grant_type' => 'refresh_token',
        'refresh_token' => $refresh_token
    ]);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);

    $response = curl_exec($ch);
    
    if (curl_errno($ch)) {
        echo 'Curl Error: ' . curl_error($ch);
        return false;
    }

    curl_close($ch);

    $responseData = json_decode($response, true);

    if (isset($responseData['access_token'])) {

        updateAccessToken($responseData);

        return $responseData['access_token'];
    } else {

        echo "Error: " . $response . "\n";
    }

}

function updateAccessToken($ref_data){

    global $conn;

    $access_token=$ref_data['access_token'];
    $refresh_token=$ref_data['refresh_token'];
    $expires_in=$ref_data['expires_in'];
    $expires_time=time() + $expires_in;

    // Check if a token entry exists
    $query = "SELECT COUNT(*) AS count FROM xero_token WHERE id = 1";
    $result = $conn->query($query);
    $row = $result->fetch_assoc();

    if ($row['count'] > 0) {
        // Update existing token
        $query = "UPDATE xero_token 
        SET  access_token = ?, refresh_token = ?, expires_in = ?, expires_time = ? 
        WHERE id = 1";
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            die("Statement preparation failed: " . $conn->error);
        }
        $stmt->bind_param('ssss',  $access_token, $refresh_token, $expires_in, $expires_time);
        $stmt->execute();
        // echo "Token updated successfully.";
    } 

}

function getTeamAccessToken(){
    global $conn;

    $query = "SELECT * FROM xero_token WHERE id = 1";
    $result = $conn->query($query);

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $currentTime = time();

        if ($row['expires_time'] > $currentTime) {
            return $row['access_token'];
        }else{
            $refreshToken=$row['refresh_token'];
            // If accesstoken expire refresh it 
            return refrechAccessToken($refreshToken);
        }
    }
}

// $token =  getTeamAccessToken();
// echo $token;
// ghl token code

function ghl_refrechAccessToken($refresh_token){
    global $client_id;
    global $client_secret;
    global $redirect_uri;

    $url = 'https://services.leadconnectorhq.com/oauth/token';

    // Create an array with the POST fields
    $data = [
        'client_id' => $client_id,
        'client_secret' => $client_secret,
        'grant_type' => 'refresh_token',
        'refresh_token' => $refresh_token,
        'redirect_uri' => $redirect_uri
    ];

    // Initialize a cURL session
    $ch = curl_init($url);

    // Set cURL options
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: application/json',
        'Content-Type: application/x-www-form-urlencoded'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));

    // Execute the cURL request
    $response = curl_exec($ch);

    curl_close($ch);
 
    $responseData = json_decode($response, true);

    if (isset($responseData['access_token'])) {

        ghl_updateAccessToken($responseData);

        return $responseData['access_token'];
    } else {

        echo "Error: " . $response . "\n";
    }

}

function ghl_updateAccessToken($ref_data){

    global $conn;

    $access_token=$ref_data['access_token'];
    $refresh_token=$ref_data['refresh_token'];
    $expires_in = $ref_data['expires_in'];
    $expires_time=time() + $expires_in;

    // Check if a token entry exists
    $query = "SELECT COUNT(*) AS count FROM GHL_token WHERE id = 1";
    $result = $conn->query($query);
    $row = $result->fetch_assoc();

    if ($row['count'] > 0) {
        // Update existing token
        $query = "UPDATE GHL_token 
        SET  access_token = ?, refresh_token = ?, expires_in = ?, expires_time = ? 
        WHERE id = 1";
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            die("Statement preparation failed: " . $conn->error);
        }
        $stmt->bind_param('ssss',  $access_token, $refresh_token, $expires_in, $expires_time);
        $stmt->execute();
    } 

}

function ghl_getAccessToken(){
    global $conn;

    $query = "SELECT * FROM GHL_token WHERE id = 1";
    $result = $conn->query($query);

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $currentTime = time();

        if ($row['expires_time'] > $currentTime) {
            return $row['access_token'];
        }else{
            $refreshToken=$row['refresh_token'];
            // If accesstoken expire refresh it 
            return ghl_refrechAccessToken($refreshToken);
        }
    }
}

// $token =  ghl_getAccessToken();
// echo $token;
